-- new script file

function OnAfterSceneLoaded(self)
  CreateTriggerTargets(self)
  CreateTriggerSources(self)  
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    self.deactivate = false
		self.p0 = Citadels.GetPlayer(0)
    
    if not self.loaded then
      self.deactivate = false  
      self.counted = false
      self.armyCount = 0
    end
    
    self.defCond:LinkToTarget("defeat")
  end
  
  if self.deactivate then
    return
  end
  
  if self.counted and self.armyCount <= 0 then
    self.p0:FailQuest('D1G_GOAL_1')
    self.defCond:TriggerAllTargets()
    self.deactivate = true
  end
  
end

function OnTrigger(self, source, target)
  if target == "unitInit" then
    self.armyCount = self.armyCount + 1
    self.counted = true
    Debug:Log("Army count = " .. self.armyCount)
  elseif target == "unitKill" then
    self.armyCount = self.armyCount - 1
    Debug:Log("Army count = " .. self.armyCount)
  elseif target == "condDeact" then
    self.deactivate = true
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
	  CreateTriggerSources(self)
	  self.loaded = true
	  self.deactivate = ar:Read()
    self.counted = ar:Read()
    self.armyCount = ar:Read()
  elseif (ar:IsSaving()) then
	  ar:Write(self.deactivate)
    ar:Write(self.counted)
    ar:Write(self.armyCount)
  end  
end

function CreateTriggerTargets(self)
  self:AddTriggerTarget("unitInit")
  self:AddTriggerTarget("unitKill")
  self:AddTriggerTarget("condDeact")
end

function CreateTriggerSources(self)
  self:AddTriggerSource("defCond")
end
